/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class VWSIMCategoryRender
extends DefaultTableCellRenderer {
    public static final int CATEGORY_SCENARIO = 0;
    public static final int CATEGORY_SIMULATION = 1;
    public static final int CATEGORY_PUBLISHED_DATA = 2;
    private static final ImageIcon ICON_SCENARIO = VWSIMImageLoader.createImageIcon("scenario_16.gif");
    private static final ImageIcon ICON_SIMULATION = VWSIMImageLoader.createImageIcon("simulation_16.gif");
    private static final ImageIcon ICON_PUBLISHED_DATA = VWSIMImageLoader.createImageIcon("pub_data_16.gif");

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setComponentOrientation(table.getComponentOrientation());
            if (value != null && value instanceof Integer) {
                JLabel aLabel = (JLabel)component;
                aLabel.setText("");
                Integer iCategory = (Integer)value;
                switch (iCategory) {
                    case 0: {
                        aLabel.setIcon(ICON_SCENARIO);
                        aLabel.setToolTipText(VWSIMResource.Scenario);
                        break;
                    }
                    case 1: {
                        aLabel.setIcon(ICON_SIMULATION);
                        aLabel.setToolTipText(VWSIMResource.Simulation);
                        break;
                    }
                    case 2: {
                        aLabel.setIcon(ICON_PUBLISHED_DATA);
                        aLabel.setToolTipText(VWSIMResource.PublishedData);
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

